% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{empty_blanks}
\alias{empty_blanks}
\title{Make blank columns as transparent}
\usage{
empty_blanks(x, width = 0.05, unit = "in", part = "all")
}
\arguments{
\item{x}{a flextable object}

\item{width}{width of blank columns (.1 inch by default).}

\item{unit}{unit for width, one of "in", "cm", "mm".}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
blank columns are set as transparent. This is a shortcut function
that will delete top and bottom borders, change background color to
transparent, display empty content and set blank columns' width.
}
\examples{
typology <- data.frame(
  col_keys = c(
    "Sepal.Length", "Sepal.Width", "Petal.Length",
    "Petal.Width", "Species"
  ),
  what = c("Sepal", "Sepal", "Petal", "Petal", " "),
  measure = c("Length", "Width", "Length", "Width", "Species"),
  stringsAsFactors = FALSE
)
typology

ftab <- flextable(head(iris), col_keys = c(
  "Species",
  "break1", "Sepal.Length", "Sepal.Width",
  "break2", "Petal.Length", "Petal.Width"
))
ftab <- set_header_df(ftab, mapping = typology, key = "col_keys")
ftab <- merge_h(ftab, part = "header")
ftab <- theme_vanilla(ftab)
ftab <- empty_blanks(ftab)
ftab <- width(ftab, j = c(2, 5), width = .1)
ftab
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{font}()},
\code{\link{fontsize}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{keep_with_next}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{tab_settings}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
