% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{set_header_labels}
\alias{set_header_labels}
\title{Rename column labels in the header}
\usage{
set_header_labels(x, ..., values = NULL)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{...}{named arguments (names are data colnames), each element is a single character
value specifying label to use.}

\item{values}{a named list (names are data colnames), each element is a single character
value specifying label to use. If provided, argument \code{...} will be ignored.
It can also be a unamed character vector, in that case, it must have the same
length than the number of columns of the flextable.}
}
\description{
Change the display labels in the bottom row of the header.
Unlike \code{\link[=set_header_df]{set_header_df()}} which replaces the entire header structure,
this function only modifies column labels in the last header row.
}
\examples{
ft <- flextable(head(iris))
ft <- set_header_labels(ft,
  Sepal.Length = "Sepal length",
  Sepal.Width = "Sepal width", Petal.Length = "Petal length",
  Petal.Width = "Petal width"
)

ft <- flextable(head(iris))
ft <- set_header_labels(ft,
  values = list(
    Sepal.Length = "Sepal length",
    Sepal.Width = "Sepal width",
    Petal.Length = "Petal length",
    Petal.Width = "Petal width"
  )
)
ft

ft <- flextable(head(iris))
ft <- set_header_labels(
  x = ft,
  values = c(
    "Sepal length",
    "Sepal width", "Petal length",
    "Petal width", "Species")
)
ft
}
\seealso{
Other functions for row and column operations in a flextable: 
\code{\link{add_body}()},
\code{\link{add_body_row}()},
\code{\link{add_footer}()},
\code{\link{add_footer_lines}()},
\code{\link{add_footer_row}()},
\code{\link{add_header}()},
\code{\link{add_header_lines}()},
\code{\link{add_header_row}()},
\code{\link{delete_columns}()},
\code{\link{delete_part}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}}
}
\concept{functions for row and column operations in a flextable}
