% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{estfun.glmmTMB}
\alias{estfun.glmmTMB}
\alias{estfun}
\title{Extract Empirical Estimating Functions}
\usage{
\method{estfun}{glmmTMB}(x, full = FALSE, cluster = getGroups(x), rawnames = FALSE, ...)
}
\arguments{
\item{x}{a \code{glmmTMB} object fitted with ML (REML is not supported).}

\item{full}{logical; if \code{TRUE}, return the full score vectors including random effects,
otherwise only the fixed effects part.}

\item{cluster}{a factor indicating the cluster structure of the data.}

\item{rawnames}{logical; if \code{TRUE}, return the raw names of the parameters as in the \code{TMB} object.
By default, \code{FALSE} such that the names are sanitized to user friendly names.}

\item{...}{additional arguments (ignored).}
}
\value{
A matrix where each row corresponds to a cluster and each column
  corresponds to a parameter in the model. The values are the empirical estimating functions
 (score vectors) for each parameter in each cluster.
}
\description{
This method for \code{\link[sandwich]{estfun}} extracts the
clusterwise score vectors (empirical estimating functions)
from a fitted \code{glmmTMB} model.
}
\note{
If crossed random effects are used in the model, this function will not correctly 
  calculate the score vectors in general, and warnings will be issued. In general,
  this function should be used with models with a single level of random effects
  or nested random effects only.
}
\examples{
m <- glmmTMB(count ~ mined + (1 | spp), data = Salamanders, family = nbinom1)
estfun(m)
estfun(m, full = TRUE)
}
