% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-abort.R
\name{local_use_cli}
\alias{local_use_cli}
\title{Use cli to format error messages}
\usage{
local_use_cli(..., format = TRUE, inline = FALSE, frame = caller_env())
}
\arguments{
\item{...}{These dots are for future extensions and must be empty.}

\item{format}{Whether to use cli at print-time to format messages
and bullets.}

\item{inline}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Whether to use
cli at throw-time to format the inline parts of a message. This
makes it possible to use cli interpolation and formatting with
\code{abort()}.}

\item{frame}{A package namespace or an environment of a running
function.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{local_use_cli()} marks a package namespace or the environment of a
running function with a special flag that instructs \code{\link[=abort]{abort()}} to
use cli to format error messages. This formatting happens lazily,
at print-time, in various places:
\itemize{
\item When an unexpected error is displayed to the user.
\item When a captured error is printed in the console, for instance via
\code{\link[=last_error]{last_error()}}.
\item When \code{\link[=conditionMessage]{conditionMessage()}} is called.
}

cli formats messages and bullets with indentation and
width-wrapping to produce a polished display of messages.
}
\section{Usage}{


To use cli formatting automatically in your package:
\enumerate{
\item Make sure \code{\link[=run_on_load]{run_on_load()}} is called from your \code{.onLoad()} hook.
\item Call \code{on_load(local_use_cli())} at the top level of your namespace.
}

It is also possible to call \code{local_use_cli()} inside a running
function, in which case the flag only applies within that function.
}

\keyword{internal}
