% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udunits.R
\name{udunits2}
\alias{udunits2}
\alias{ud_are_convertible}
\alias{ud_convert}
\title{\pkg{udunits2} utilities}
\usage{
ud_are_convertible(from, to, ...)

ud_convert(x, from, to)
}
\arguments{
\item{from, to}{character vector or object of class \code{symbolic_units},
for the symbol(s) of the original unit(s) and the unit to convert to respectively.}

\item{...}{unused.}

\item{x}{numeric vector}
}
\value{
\code{ud_are_convertible}
returns \code{TRUE} if both units exist and are convertible,
\code{FALSE} otherwise.

\code{ud_convert}
returns a numeric vector with \code{x} converted to new unit.
}
\description{
Some \pkg{udunits2} utilities are exposed to the user. These functions are
useful for checking whether units are convertible or converting between units
without having to create \pkg{units} objects.
Arguments are recycled if necessary.
}
\examples{
ud_are_convertible(c("m", "mm"), "km")
ud_convert(c(100, 100000), c("m", "mm"), "km")

a <- set_units(1:3, m/s)
ud_are_convertible(units(a), "km/h")
ud_convert(1:3, units(a), "km/h")

ud_are_convertible("degF", "degC")
ud_convert(32, "degF", "degC")
}
