// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from OverCurrentProtectorTripSensor.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class OverCurrentProtectorTripSensor_1_1_11 : Com.Raritan.Idl.sensors.StateSensor_4_0_5 {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.OverCurrentProtectorTripSensor:1.1.11", Com.Raritan.Idl.sensors.StateSensor_4_0_5.typeInfo);

    public OverCurrentProtectorTripSensor_1_1_11(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public OverCurrentProtectorTripSensor_1_1_11(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new OverCurrentProtectorTripSensor_1_1_11 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new OverCurrentProtectorTripSensor_1_1_11(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class TripEventInformation : ICloneable {
      public object Clone() {
        TripEventInformation copy = new TripEventInformation();
        copy.cause = this.cause;
        copy.timestamp = this.timestamp;
        copy.current = this.current;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["cause"] = this.cause != null ? this.cause.Encode() : JsonValue.Null;
        json["timestamp"] = (this.timestamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["current"] = this.current;
        return json;
      }

      public static TripEventInformation Decode(LightJson.JsonObject json, Agent agent) {
        TripEventInformation inst = new TripEventInformation();
        inst.cause = Com.Raritan.Idl.pdumodel.Outlet_3_0_1.StaticCast(ObjectProxy.Decode(json["cause"], agent));
        inst.timestamp = new System.DateTime(json["timestamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.current = (double)json["current"];
        return inst;
      }

      public Com.Raritan.Idl.pdumodel.Outlet_3_0_1 cause = null;
      public System.DateTime timestamp = new System.DateTime(0);
      public double current = 0.0;
    }

    public class TripStateChangedEvent : Com.Raritan.Idl.sensors.StateSensor_4_0_5.StateChangedEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.OverCurrentProtectorTripSensor_1_1_11.TripStateChangedEvent:1.0.0", Com.Raritan.Idl.sensors.StateSensor_4_0_5.StateChangedEvent.typeInfo);

      public Com.Raritan.Idl.pdumodel.Outlet_3_0_1 tripCause = null;
      public Com.Raritan.Idl.pdumodel.OverCurrentProtectorTripSensor_1_1_11.TripEventInformation tripInformation = new Com.Raritan.Idl.pdumodel.OverCurrentProtectorTripSensor_1_1_11.TripEventInformation();
    }

    public class GetTripCauseResult {
      public Com.Raritan.Idl.pdumodel.Outlet_3_0_1 _ret_;
    }

    public GetTripCauseResult getTripCause() {
      JsonObject _parameters = null;
      var _result = RpcCall("getTripCause", _parameters);
      var _ret = new GetTripCauseResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Outlet_3_0_1.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
      return _ret;
    }

    public AsyncRequest getTripCause(AsyncRpcResponse<GetTripCauseResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTripCause(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTripCause(AsyncRpcResponse<GetTripCauseResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getTripCause", _parameters,
        _result => {
          try {
            var _ret = new GetTripCauseResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Outlet_3_0_1.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetTripEventInformationResult {
      public Com.Raritan.Idl.pdumodel.OverCurrentProtectorTripSensor_1_1_11.TripEventInformation _ret_;
    }

    public GetTripEventInformationResult getTripEventInformation() {
      JsonObject _parameters = null;
      var _result = RpcCall("getTripEventInformation", _parameters);
      var _ret = new GetTripEventInformationResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.OverCurrentProtectorTripSensor_1_1_11.TripEventInformation.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getTripEventInformation(AsyncRpcResponse<GetTripEventInformationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTripEventInformation(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTripEventInformation(AsyncRpcResponse<GetTripEventInformationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getTripEventInformation", _parameters,
        _result => {
          try {
            var _ret = new GetTripEventInformationResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.OverCurrentProtectorTripSensor_1_1_11.TripEventInformation.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetTripWaveformResult {
      public Com.Raritan.Idl.pdumodel.Waveform _ret_;
    }

    public GetTripWaveformResult getTripWaveform() {
      JsonObject _parameters = null;
      var _result = RpcCall("getTripWaveform", _parameters);
      var _ret = new GetTripWaveformResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Waveform.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getTripWaveform(AsyncRpcResponse<GetTripWaveformResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTripWaveform(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTripWaveform(AsyncRpcResponse<GetTripWaveformResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getTripWaveform", _parameters,
        _result => {
          try {
            var _ret = new GetTripWaveformResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Waveform.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
