/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// Match : GeoCoding match
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Match {
    #[serde(rename = "type")]
    pub r#type: models::LocationType,
    /// Experimental. Type categories might be adjusted.  For OSM stop locations: the amenity type based on https://wiki.openstreetmap.org/wiki/OpenStreetMap_Carto/Symbols 
    #[serde(rename = "category", skip_serializing_if = "Option::is_none")]
    pub category: Option<String>,
    /// list of non-overlapping tokens that were matched
    #[serde(rename = "tokens")]
    pub tokens: Vec<Vec<f64>>,
    /// name of the location (transit stop / PoI / address)
    #[serde(rename = "name")]
    pub name: String,
    /// unique ID of the location
    #[serde(rename = "id")]
    pub id: String,
    /// latitude
    #[serde(rename = "lat")]
    pub lat: f64,
    /// longitude
    #[serde(rename = "lon")]
    pub lon: f64,
    /// level according to OpenStreetMap (at the moment only for public transport) 
    #[serde(rename = "level", skip_serializing_if = "Option::is_none")]
    pub level: Option<f64>,
    /// street name
    #[serde(rename = "street", skip_serializing_if = "Option::is_none")]
    pub street: Option<String>,
    /// house number
    #[serde(rename = "houseNumber", skip_serializing_if = "Option::is_none")]
    pub house_number: Option<String>,
    /// ISO3166-1 country code from OpenStreetMap
    #[serde(rename = "country", skip_serializing_if = "Option::is_none")]
    pub country: Option<String>,
    /// zip code
    #[serde(rename = "zip", skip_serializing_if = "Option::is_none")]
    pub zip: Option<String>,
    /// timezone name (e.g. \"Europe/Berlin\")
    #[serde(rename = "tz", skip_serializing_if = "Option::is_none")]
    pub tz: Option<String>,
    /// list of areas
    #[serde(rename = "areas")]
    pub areas: Vec<models::Area>,
    /// score according to the internal scoring system (the scoring algorithm might change in the future)
    #[serde(rename = "score")]
    pub score: f64,
    /// available transport modes for stops
    #[serde(rename = "modes", skip_serializing_if = "Option::is_none")]
    pub modes: Option<Vec<models::Mode>>,
    /// importance of a stop, normalized from [0, 1]
    #[serde(rename = "importance", skip_serializing_if = "Option::is_none")]
    pub importance: Option<f64>,
}

impl Match {
    /// GeoCoding match
    pub fn new(r#type: models::LocationType, tokens: Vec<Vec<f64>>, name: String, id: String, lat: f64, lon: f64, areas: Vec<models::Area>, score: f64) -> Match {
        Match {
            r#type,
            category: None,
            tokens,
            name,
            id,
            lat,
            lon,
            level: None,
            street: None,
            house_number: None,
            country: None,
            zip: None,
            tz: None,
            areas,
            score,
            modes: None,
            importance: None,
        }
    }
}

