---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, accolades, 
              accolages horizontales, opérateurs
---

# Comment obtenir des accolades horizontales ?

## Avec les commandes de base

Les commandes `\overbrace` et `\underbrace` permettent respectivement d'obtenir
des accolades horizontales au-dessus ou au-dessous de leur argument :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[  \overbrace{f(x)}^{=0} + \underbrace{g(y)}_{=0} = 0 \]
\end{document}
```


## Avec l'extension <ctanpkg:oubraces>

L'extension <ctanpkg:oubraces> permet d'entrelacer des accolades `overbrace` 
et `underbrace` :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{oubraces}

\begin{document}
\[
  \overunderbraces{&\br{2}{x}& &\br{2}{y}}%
    {a + b +&c + d +&e + f&+&g + h&+ i + j&+ k + l}%
    {& &\br{3}{z}}
  = \pi r^2
\]
\end{document}
```