#include <stdlib.h>

#include "util.h"

void *array_add(struct array *arr, size_t size) {
	size_t new_cap = arr->cap;
	if (new_cap == 0) {
		new_cap = 64;
	}
	while (new_cap < arr->size + size) {
		new_cap *= 2;
	}
	if (arr->cap != new_cap) {
		void *new_data = realloc(arr->data, new_cap);
		if (new_data == NULL) {
			abort();
		}
		arr->data = new_data;
		arr->cap = new_cap;
	}

	char *data = arr->data;
	void *entry = &data[arr->size];
	arr->size += size;
	return entry;
}

void array_finish(struct array *arr) {
	free(arr->data);
}
